/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.core.Action;
import com.jfinal.render.ContentType;
import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;
import io.jboot.web.render.JbootErrorRender;
import io.jboot.web.render.JbootHtmlRender;
import io.jboot.web.render.JbootJavascriptRender;
import io.jboot.web.render.JbootJsonRender;
import io.jboot.web.render.JbootRedirect301Render;
import io.jboot.web.render.JbootRedirectRender;
import io.jboot.web.render.JbootRender;
import io.jboot.web.render.JbootReturnValueRender;
import io.jboot.web.render.JbootTemplateRender;
import io.jboot.web.render.JbootTextRender;
import io.jboot.web.render.JbootXmlRender;

public class JbootRenderFactory
extends RenderFactory {
    private static final JbootRenderFactory ME = new JbootRenderFactory();

    public static final JbootRenderFactory me() {
        return ME;
    }

    public Render getRender(String view) {
        return new JbootRender(view);
    }

    public Render getHtmlRender(String htmlText) {
        return new JbootHtmlRender(htmlText);
    }

    public Render getTextRender(String text) {
        return new JbootTextRender(text);
    }

    public Render getTextRender(String text, String contentType) {
        return new JbootTextRender(text, contentType);
    }

    public Render getTextRender(String text, ContentType contentType) {
        return new JbootTextRender(text, contentType);
    }

    public Render getJavascriptRender(String jsText) {
        return new JbootJavascriptRender(jsText);
    }

    public Render getErrorRender(int errorCode) {
        return new JbootErrorRender(errorCode, this.constants.getErrorView(errorCode));
    }

    public Render getErrorRender(int errorCode, String view) {
        return new JbootErrorRender(errorCode, view);
    }

    public Render getJsonRender() {
        return new JbootJsonRender();
    }

    public Render getJsonRender(String key, Object value) {
        return new JbootJsonRender(key, value);
    }

    public Render getJsonRender(String[] attrs) {
        return new JbootJsonRender(attrs);
    }

    public Render getJsonRender(String jsonText) {
        return new JbootJsonRender(jsonText);
    }

    public Render getJsonRender(Object object) {
        return new JbootJsonRender(object);
    }

    public Render getTemplateRender(String view) {
        return new JbootTemplateRender(view);
    }

    public Render getXmlRender(String view) {
        return new JbootXmlRender(view);
    }

    public Render getRedirectRender(String url) {
        return new JbootRedirectRender(url);
    }

    public Render getRedirectRender(String url, boolean withQueryString) {
        return new JbootRedirectRender(url, withQueryString);
    }

    public Render getRedirect301Render(String url) {
        return new JbootRedirect301Render(url);
    }

    public Render getRedirect301Render(String url, boolean withQueryString) {
        return new JbootRedirect301Render(url, withQueryString);
    }

    public Render getReturnValueRender(Action action, Object returnValue) {
        return new JbootReturnValueRender(action, returnValue);
    }
}

