/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.kit.JsonKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import io.jboot.web.ResponseEntity;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class JbootResponseEntityRender
extends Render {
    private ResponseEntity responseEntity;

    public JbootResponseEntityRender(ResponseEntity responseEntity) {
        this.responseEntity = responseEntity;
    }

    public void render() {
        PrintWriter writer = null;
        try {
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Content-Type", "application/json; charset=utf-8");
            this.response.setStatus(this.responseEntity.getHttpStatus().value());
            Map<String, String> headers = this.responseEntity.getHeaders();
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.response.setHeader(entry.getKey(), entry.getValue());
                }
            }
            String jsonText = this.responseEntity.getBody() == null ? "" : JsonKit.toJson(this.responseEntity.getBody());
            writer = this.response.getWriter();
            writer.write(jsonText);
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }
}

