/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.session;

import io.jboot.Jboot;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheManager;
import io.jboot.utils.StrUtil;
import io.jboot.web.session.JbootHttpSession;
import io.jboot.web.session.JbootSessionConfig;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class JbootServletRequestWrapper
extends HttpServletRequestWrapper {
    private static JbootSessionConfig config = Jboot.config(JbootSessionConfig.class);
    private static int maxInactiveInterval = config.getMaxInactiveInterval();
    private static String cookieName = config.getCookieName();
    private static String cookiePath = config.getCookieContextPath();
    private static String cookieDomain = config.getCookieDomain();
    private static int cookieMaxAge = config.getCookieMaxAge();
    private static String cacheName = config.getCacheName();
    private static String cacheType = config.getCacheType();
    private static JbootCache jbootCache = JbootCacheManager.me().getCache(StrUtil.isBlank((String)cacheType) || "none".equals(cacheType) ? "ehcache" : cacheType);
    private HttpServletResponse response;
    private HttpServletRequest originRequest;
    private JbootHttpSession jbootSession;

    public JbootServletRequestWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(request);
        this.originRequest = request;
        this.response = response;
    }

    public HttpSession getSession() {
        return this.getSession(false);
    }

    public HttpSession getSession(boolean create) {
        if (this.jbootSession != null) {
            return this.jbootSession;
        }
        String sessionId = this.getCookie(cookieName);
        if (sessionId != null) {
            this.jbootSession = new JbootHttpSession(sessionId, this.originRequest.getServletContext(), this.createSessionStore(sessionId));
            this.jbootSession.setMaxInactiveInterval(maxInactiveInterval);
        } else if (create) {
            sessionId = UUID.randomUUID().toString().replace("-", "");
            this.jbootSession = new JbootHttpSession(sessionId, this.originRequest.getServletContext(), this.createSessionStore(sessionId));
            this.jbootSession.setMaxInactiveInterval(maxInactiveInterval);
            this.setCookie(cookieName, sessionId, cookieMaxAge);
        }
        return this.jbootSession;
    }

    private Map<String, Object> createSessionStore(String sessionId) {
        HashMap<String, Object> store = (HashMap<String, Object>)jbootCache.get(cacheName, sessionId);
        if (store == null) {
            Enumeration names;
            store = new HashMap<String, Object>();
            HttpSession originSession = this.originRequest.getSession();
            if (originSession != null && (names = originSession.getAttributeNames()) != null) {
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    store.put(name, originSession.getAttribute(name));
                }
            }
        }
        return store;
    }

    public void refreshSession() {
        if (this.jbootSession == null) {
            return;
        }
        if (this.jbootSession.isEmpty() || !this.jbootSession.isValid()) {
            jbootCache.remove(cacheName, this.jbootSession.getId());
            this.setCookie(cookieName, null, 0);
        } else if (this.jbootSession.isDataChanged()) {
            Map<String, Object> snapshot = this.jbootSession.snapshot();
            if (snapshot.isEmpty()) {
                jbootCache.remove(cacheName, this.jbootSession.getId());
                this.setCookie(cookieName, null, 0);
            } else {
                jbootCache.put(cacheName, this.jbootSession.getId(), snapshot, maxInactiveInterval);
            }
        } else {
            jbootCache.setTtl(cacheName, this.jbootSession.getId(), maxInactiveInterval);
        }
    }

    private String getCookie(String name) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : null;
    }

    private Cookie getCookieObject(String name) {
        Cookie[] cookies = this.originRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    private void setCookie(String name, String value, int maxAgeInSeconds) {
        if (!this.response.isCommitted()) {
            Cookie cookie = new Cookie(name, value);
            cookie.setMaxAge(maxAgeInSeconds);
            cookie.setPath(cookiePath);
            if (cookieDomain != null) {
                cookie.setDomain(cookieDomain);
            }
            cookie.setHttpOnly(true);
            this.response.addCookie(cookie);
        }
    }

    public HttpServletRequest getOriginRequest() {
        return this.originRequest;
    }
}

