/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.validate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.kit.Ret;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.fixedinterceptor.FixedInterceptor;
import io.jboot.web.validate.CaptchaValidate;
import io.jboot.web.validate.EmptyValidate;
import java.lang.reflect.Method;

public class ParaValidateInterceptor
implements FixedInterceptor {
    @Override
    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        EmptyValidate emptyParaValidate = method.getAnnotation(EmptyValidate.class);
        if (emptyParaValidate != null && !this.validateEmpty(inv, emptyParaValidate)) {
            return;
        }
        CaptchaValidate captchaValidate = method.getAnnotation(CaptchaValidate.class);
        if (captchaValidate != null && !this.validateCaptache(inv, captchaValidate)) {
            return;
        }
        inv.invoke();
    }

    private boolean validateCaptache(Invocation inv, CaptchaValidate captchaValidate) {
        String formName = AnnotationUtil.get(captchaValidate.form());
        if (StrUtil.isBlank((String)formName)) {
            throw new IllegalArgumentException("@CaptchaValidate.form must not be empty in " + inv.getController().getClass().getName() + "." + inv.getMethodName());
        }
        Controller controller = inv.getController();
        if (controller.validateCaptcha(formName)) {
            return true;
        }
        this.renderError(inv.getController(), AnnotationUtil.get(captchaValidate.renderType()), formName, AnnotationUtil.get(captchaValidate.message()), AnnotationUtil.get(captchaValidate.redirectUrl()), AnnotationUtil.get(captchaValidate.htmlPath()), captchaValidate.errorCode());
        return false;
    }

    private boolean validateEmpty(Invocation inv, EmptyValidate emptyParaValidate) {
        Object[] forms = emptyParaValidate.value();
        if (ArrayUtil.isNullOrEmpty(forms)) {
            return true;
        }
        for (Object form : forms) {
            String formName = AnnotationUtil.get(form.name());
            String formType = AnnotationUtil.get(form.type());
            if (StrUtil.isBlank((String)formName)) {
                throw new IllegalArgumentException("@Form.value must not be empty in " + inv.getController().getClass().getName() + "." + inv.getMethodName());
            }
            String value = null;
            if ("form".equalsIgnoreCase(formType)) {
                value = inv.getController().getPara(formName);
            } else if ("raw".equalsIgnoreCase(formType)) {
                try {
                    Object tmp;
                    JSONObject json = JSON.parseObject((String)inv.getController().getRawData());
                    if (json != null && (tmp = JSONPath.eval((Object)json, (String)("$." + formName))) != null) {
                        value = tmp.toString();
                    }
                }
                catch (Exception e) {
                    value = null;
                }
            } else {
                throw new IllegalArgumentException("para validate not support form type : " + formType + ", see : io.jboot.web.controller.validate.FormType");
            }
            if (value != null && value.trim().length() != 0) continue;
            this.renderError(inv.getController(), AnnotationUtil.get(emptyParaValidate.renderType()), formName, AnnotationUtil.get(form.message()), AnnotationUtil.get(emptyParaValidate.redirectUrl()), AnnotationUtil.get(emptyParaValidate.htmlPath()), form.errorCode());
            return false;
        }
        return true;
    }

    private void renderError(Controller controller, String renderType, String formName, String message, String redirectUrl, String htmlPath, int errorCode) {
        switch (renderType) {
            case "default": {
                if (RequestUtil.isAjaxRequest(controller.getRequest())) {
                    controller.renderJson((Object)Ret.fail((Object)"message", (Object)message).set((Object)"errorCode", (Object)errorCode).setIfNotNull((Object)"formName", (Object)formName));
                    break;
                }
                controller.renderError(404);
                break;
            }
            case "json": {
                controller.renderJson((Object)Ret.fail((Object)"message", (Object)message).set((Object)"errorCode", (Object)errorCode).setIfNotNull((Object)"formName", (Object)formName));
                break;
            }
            case "redirect": {
                controller.redirect(redirectUrl);
                break;
            }
            case "html": {
                controller.render(htmlPath);
                break;
            }
            case "text": {
                controller.renderText(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("can not process render : " + renderType);
            }
        }
    }
}

